/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.neoforge.proxy;

import com.stevekung.fishofthieves.FishOfThievesClient;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.config.FishOfThievesConfig;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

public class ClientProxyNeoForge {
    public void init() {
        IEventBus eventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, screen) -> (Screen)AutoConfig.getConfigScreen(FishOfThievesConfig.class, (Screen)screen).get());
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::registerRenderers);
        eventBus.addListener(this::registerLayerDefinitions);
        eventBus.addListener(this::registerLayers);
        eventBus.addListener(this::registerBlockColors);
        eventBus.addListener(this::registerItemColors);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        FishOfThievesClient.registerBlockEntityRenderers();
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        FishOfThievesClient.getEntityRenderers().forEach(entry -> event.registerEntityRenderer(entry.entityType(), entry.factory()));
    }

    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        FishOfThievesClient.getModelLayers().forEach(entry -> event.registerLayerDefinition(entry.layerLocation(), entry.supplier()));
    }

    private void registerLayers(EntityRenderersEvent.AddLayers event) {
        FishOfThievesClient.getHeadphone().forEach(entry -> ClientProxyNeoForge.addHeadphoneLayer(event, entry.entityType(), entry.scaleable()));
    }

    private void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{FOTBlocks.MANGO_LEAVES});
        event.register((blockState, level, pos, tintIndex) -> level != null && pos != null && tintIndex == 1 ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{FOTBlocks.MANGO_FRUIT, FOTBlocks.HANGING_MANGO_FRUIT});
    }

    private void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((itemStack, tintIndex) -> FoliageColor.getDefaultColor(), new ItemLike[]{FOTBlocks.MANGO_LEAVES});
    }

    private static <M extends EntityModel<LivingEntity>> void addHeadphoneLayer(EntityRenderersEvent.AddLayers event, EntityType<? extends LivingEntity> entityType, HeadphoneModel.Scaleable<LivingEntity> scaleable) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)event.getRenderer(entityType);
        if (renderer != null) {
            renderer.addLayer(new HeadphoneLayer(renderer, event.getEntityModels(), scaleable));
        }
    }
}

